//Battle Menu
function BattleMenu()
{
  if (this instanceof BattleMenu == false) {
    return new BattleMenu();
  }

  // default properties
  this.mfont            = LoadFont("New.rfn")
  this.window_style    = GetSystemWindowStyle()
  this.arrow           = GetSystemArrow();
  this.up_arrow        = LoadImage("Arrow_Up.png");
  this.down_arrow      = LoadImage("Arrow_Down.png");
  this.escape_function = function() { }

  this.items = new Array();
}

// add item
BattleMenu.prototype.addItem = function(name, callback, color) {

  if (color == undefined) {
    color = White;
  }

  var item = new Object;
  item.name     = name;
  item.callback = callback;
  item.color    = color;
  this.items[this.items.length] = item;
}

// execute
BattleMenu.prototype.execute = function(x, y, w, h, sel) {
  with (this) {
    window_style.drawWindow(x, y, w, h);
    var background = GrabImage(0, 0, GetScreenWidth(), GetScreenHeight());

    var text_height = mfont.getHeight();
    var shown_items = Math.floor(h / text_height);
    if (sel == undefined)
    {
    var selection = 0;
    }
    else
    {
    var selection = sel;
    }
    var top_selection = 0;

    while (true) {
      // draw background
      background.blit(0, 0);

      // draw the menu items
      for (var i = 0; i < shown_items; i++) {
        if (i < items.length) {
          mfont.setColorMask(Black);
          mfont.drawText(x + 32 + 1, y + i * text_height + 1, items[i + top_selection].name);
          mfont.setColorMask(items[i + top_selection].color);
          mfont.drawText(x + 32,     y + i * text_height,     items[i + top_selection].name);
        }
      }

      // draw the selection arrow
      arrow.blit(x, y + (selection - top_selection) * text_height);

      // draw the up and down arrows if necessary
      if (top_selection > 0) {
        up_arrow.blit(x + w - up_arrow.width, y);
      }
      if (top_selection + shown_items < items.length) {
        down_arrow.blit(x + w - down_arrow.width, y + text_height * shown_items - down_arrow.height);
      }

      FlipScreen();

      // handle keypresses
      while (AreKeysLeft()) {
        switch (GetKey()) {
          case KEY_ENTER: {
            var item = items[selection];
		if (item.color == Gray)
	        {
		OverRide(Beep,false);
		break;
		}
		else
		{
		SetDelayScript(0, item.callback);
		return;
		}
          }

          case KEY_ESCAPE: {
	    OverRide(Cancel,false);
            escape_function();
            return;
          }

          case KEY_DOWN: {
            if (selection < items.length - 1) {
	    OverRide(Mmove,false);
              selection++;
              if (selection >= top_selection + shown_items) {
                top_selection++;
              }
            }
            break;
          }

          case KEY_UP: {
            if (selection > 0) {
	    OverRide(Mmove,false);
              selection--;
              if (selection < top_selection) {
                top_selection--;
              }
            }
            break;
          }

        }
      } // end handle input
    }

  } // end with
}


function MoveMenu()
{
  if (this instanceof MoveMenu == false) {
    return new MoveMenu();
  }

  // default properties
  this.font             = GetSystemFont()
  this.window_style = GetSystemWindowStyle()
  this.arrow           = GetSystemArrow();
  this.up_arrow      = LoadImage("Arrow_Up.png");
  this.down_arrow  = LoadImage("Arrow_Down.png");
  this.escape_function = function() { }

  this.items = new Array();
}

// add item
MoveMenu.prototype.addItem = function(name, callback, x) {

  var item = new Object;
}

// execute
MoveMenu.prototype.execute = function(x, y, w, h) {
  with (this) {

    var selection = 0;
    var top_selection = 0;
    var Moves = Battle.movesleft;
    var set_tiles = true;

    EatKey();

    while (true) {
      Battle.movesleft = Moves;



      if (set_tiles == true)
      {
	for (i=-3; i< 4; i++)
	{
		for (j=-3; j<4;j++)
		{
		SetTile(player[Battle.temp].x+i, player[Battle.temp].y+j, 2, 0); 
		}
	}


      if (BattleObstruct((player[Battle.temp].x + 1)*Game.tilesize+Game.tilesize/2-1, (player[Battle.temp].y)*Game.tilesize+Game.tilesize/2 -1) == false) 
      {
      SetTile(player[Battle.temp].x+1, player[Battle.temp].y, 2, 1); 
      }
      else
      {
      SetTile(player[Battle.temp].x+1, player[Battle.temp].y, 2, 2); 
      }

      if (BattleObstruct((player[Battle.temp].x)*Game.tilesize+Game.tilesize/2-1, (player[Battle.temp].y+1)*Game.tilesize+Game.tilesize/2 -1) == false)
      {
      SetTile(player[Battle.temp].x, player[Battle.temp].y+1, 2, 1); 
      }
      else
      {
      SetTile(player[Battle.temp].x, player[Battle.temp].y+1, 2, 2); 
      }

      if (BattleObstruct((player[Battle.temp].x-1)*Game.tilesize+Game.tilesize/2-1, player[Battle.temp].y*Game.tilesize+Game.tilesize/2 -1) == false)
      {
      SetTile(player[Battle.temp].x-1, player[Battle.temp].y, 2, 1); 
      }
      else
      {
      SetTile(player[Battle.temp].x-1, player[Battle.temp].y, 2, 2); 
      }

      if (BattleObstruct((player[Battle.temp].x)*Game.tilesize+Game.tilesize/2-1, (player[Battle.temp].y-1)*Game.tilesize+Game.tilesize/2 -1) == false)
      {
      SetTile(player[Battle.temp].x, player[Battle.temp].y-1, 2, 1); 
      }
      else
      {
      SetTile(player[Battle.temp].x, player[Battle.temp].y-1, 2, 2); 
      }
      set_tiles = false;
      }

      RenderMap();
      BattleDraw1(true);
      FlipScreen();

      // handle keypresses
      while (AreKeysLeft()) 
      {
        switch (GetKey()) 
        {
          case KEY_ENTER: 
          {
          //Finish moving
	    OverRide(Accept,false);
	      for (i=-2; i< 3; i++)
	      {
		for (j=-2; j<3;j++)
		{
		SetTile(player[Battle.temp].x+i, player[Battle.temp].y+j, 2, 0); 
		}
	      }
	    Battle.movesleft = Moves;
	      if (Battle.attacked == false || Battle.movesleft > 0)
	      {
              escape_function();
	      }
	      else
	      {
	      EndTurn();
	      }
            return;
          }

          case KEY_ESCAPE: 
	  {
	    OverRide(Cancel,false);
	      for (i=-2; i< 3; i++)
	      {
		for (j=-2; j<3;j++)
		{
		SetTile(player[Battle.temp].x+i, player[Battle.temp].y+j, 2, 0); 
		}
	      }

	    Battle.movesleft = Moves;
	      if (Battle.attacked == false || Battle.movesleft > 0)
	      {
              escape_function();
	      }
	      else
	      {
	      EndTurn();
	      }
            return;
          }

          case KEY_RIGHT: 
          {
            if (GetTile(player[Battle.temp].x + 1, player[Battle.temp].y, 2) == 2 || Moves <= 0)
	    {
	    OverRide(Beep,false);
            }
            else
            {
            Moves = Moves -1;
	    player[Battle.temp].x = player[Battle.temp].x +1;
	    set_tiles = true;
            Move("player" + Battle.temp, "right", 1, true);
            }
	    break;
          }

          case KEY_UP: 
          {
          
            if (GetTile(player[Battle.temp].x, player[Battle.temp].y-1, 2) == 2 || Moves <= 0)
	    {
	    OverRide(Beep,false);
            }
            else
            {
            Moves = Moves -1;
	    player[Battle.temp].y = player[Battle.temp].y - 1;
	    set_tiles = true;
            Move("player" + Battle.temp, "up", 1, true);
            }
	    
            break;
          }
          case KEY_DOWN: 
          {
            if (GetTile(player[Battle.temp].x, player[Battle.temp].y+1, 2) == 2 || Moves <= 0)
	    {
	    OverRide(Beep,false);
            }
            else
            {
            Moves = Moves -1;
	    player[Battle.temp].y = player[Battle.temp].y + 1;
	    set_tiles = true;
            Move("player" + Battle.temp, "down", 1, true);
            }
	    break;
          }
	  
          case KEY_LEFT: 
          {
            if (GetTile(player[Battle.temp].x-1, player[Battle.temp].y, 2) == 2 || Moves <= 0)
	    {
	    OverRide(Beep,false);
            }
            else
            {
            Moves = Moves -1;
	    player[Battle.temp].x = player[Battle.temp].x -1;
	    set_tiles = true;
            Move("player" + Battle.temp, "left", 1, true);
            }
	    break;
          }
        }
      } // end handle input
    }
  } // end with
}


function AttackMenu()
{
  if (this instanceof AttackMenu == false) {
    return new AttackMenu();
  }

  // default properties
  this.font             = GetSystemFont()
  this.window_style = GetSystemWindowStyle()
  this.arrow           = GetSystemArrow();
  this.up_arrow      = LoadImage("Arrow_Up.png");
  this.down_arrow  = LoadImage("Arrow_Down.png");
  this.escape_function = function() { }

  this.items = new Array();
}

// add item
AttackMenu.prototype.addItem = function() {

  var item = new Object;
}

// execute
AttackMenu.prototype.execute = function(spread, type) {
  with (this) {

    var selx = player[Battle.temp].x;
    var sely = player[Battle.temp].y;
    var swordtype = false;
    var TheDamage = 0;
	if (spread == undefined)
	{
	spread = 1;
	}
    GetScreenPosition(selx*Game.tilesize, sely*Game.tilesize);

    while (true) {

      RenderMap();

	if (GetTile(selx, sely, 2) == 4)
	{
	swordtype = false;
		if (type == true)
		{
			if  (Skill[Battle.tempskill][4] >= 0 || Skill[Battle.tempskill][4] < - 10 || Skill[Battle.tempskill][7] >= 0)
			{
			var HpDamage = 0;
			var MpDamage = 0;
				if (Skill[Battle.tempskill][3] == 0 || Skill[Battle.tempskill][3] == 3)
				{
					if (Skill[Battle.tempskill][10] > 0)
					{
					HpDamage = Math.floor(Skill[Battle.tempskill][4]*((100-player[PXY(selx,sely)][Skill[Battle.tempskill][10]-8])/100));
					}
					else
					{
					HpDamage = Math.floor(Skill[Battle.tempskill][4]);
					}

					if (Skill[Battle.tempskill][10] == 36 && player[PXY(selx,sely)][28] < 0 && HpDamage < 0)
					{
					HpDamage = HpDamage *(-1);
					}
				}
				else if (Skill[Battle.tempskill][3] == 1 || Skill[Battle.tempskill][3] == 4)//mp damage
				{
					if (Skill[Battle.tempskill][10] > 0)
					{
					MpDamage = Math.floor(Skill[Battle.tempskill][4]*((100-player[PXY(selx,sely)][Skill[Battle.tempskill][10]-8])/100))
					}
					else
					{
					MpDamage = Math.floor(Skill[Battle.tempskill][4])
					}
				}

				HpDamage = Math.round(HpDamage + HpDamage*0.02*(player[Battle.temp][14] - player[PXY(selx,sely)][14]));
				MpDamage = Math.round(MpDamage + MpDamage*0.02*(player[Battle.temp][14] - player[PXY(selx,sely)][14]));
				BattleDraw2(PXY(selx,sely), HpDamage, MpDamage);
			}
			else
			{
			swordtype = true;
			}
		}
		if (type == false)//Item target menu thingy
		{
		var HpDamage = 0;
		var MpDamage = 0;
			if (Item[ItemPlace[Game.temp1st].num].type1 == 0 || Item[ItemPlace[Game.temp1st].num].type1 == 2)
			{
			HpDamage = Item[ItemPlace[Game.temp1st].num].effect;
			}

			if (Item[ItemPlace[Game.temp1st].num].type1 == 1 || Item[ItemPlace[Game.temp1st].num].type1 == 2)
			{
			MpDamage = Item[ItemPlace[Game.temp1st].num].effect;
			}

		BattleDraw2(PXY(selx,sely), HpDamage, MpDamage);
		}
		else if (type == true && swordtype == false)
		{
		}
		else
		{
			if (swordtype == true)
			{
				TheDamage = Math.floor((player[Battle.temp].Damage* Skill[Battle.tempskill][4] * (-1) + player[Battle.temp].Damage* Skill[Battle.tempskill][4] * (-1)*0.01*(player[Battle.temp][16] - player[PXY(selx,sely)][17]))*player[Battle.temp].Amod/player[PXY(selx,sely)].Dmod);
			}
			else
			{
				TheDamage = Math.floor((player[Battle.temp].Damage + player[Battle.temp].Damage*0.03*player[Battle.temp].Amod/player[PXY(selx,sely)].Dmod*(player[Battle.temp][16] - player[PXY(selx,sely)][17])));
			}
		TheDamage = Math.floor(TheDamage + (area[BattleArea[Battle.tempareanum].areainfo][GetTile(player[Battle.temp].x, player[Battle.temp].y, 0) - 5].elv - area[BattleArea[Battle.tempareanum].areainfo][GetTile(player[PXY(selx,sely)].x, player[PXY(selx,sely)].y,0) -5].elv)*Battle.elvdamage*TheDamage);



		Battle.temp3 = 0;
		Battle.temp4 = 0;
		//Elemental damage
			for (a=0; a<8; a++)
			{
				if (player[Battle.temp][30+a] > 0)
				{
				Battle.temp3 = Battle.temp3 + (TheDamage*(player[Battle.temp][30+a]/100*(100-player[PXY(selx,sely)][22+a])/100));
				Battle.temp4 = Battle.temp4 + player[Battle.temp][30+a]/100
				}
			}

		if (swordtype == false)
		{
		BattleDraw2(PXY(selx,sely), Math.floor((1-Battle.temp4)*TheDamage + Battle.temp3), Math.floor(player[Battle.temp].MpDamage*player[Battle.temp][16]/player[PXY(selx,sely)][17]));
		}
		else
		{
		BattleDraw2(PXY(selx,sely), Math.floor((1-Battle.temp4)*TheDamage + Battle.temp3), 0);
		}

		}
	}

      BattleDraw1(false);
      if (type == true)
      {
      TargetArrow(Skill[Battle.tempskill][12], Game.C1-2, Game.C2+64)
      }
      else
      {
      TArrow1.blit(Game.C1-2,Game.C2+64)
      }

      FlipScreen();

      // handle keypresses
      while (AreKeysLeft()) 
      {
        switch (GetKey()) 
        {
	  case KEY_ENTER:
	  {
		if (type == undefined)
		{
			if (GetTile(selx, sely, 2) == 4)
			{
			      for (i=-range -1; i< range+1; i++)
			      {
				for (j=-range -1; j<range+1;j++)
				{
				SetTile(player[Battle.temp].x+i, player[Battle.temp].y+j, 2, 0); 
				}
			      }
			OverRide(Accept,false);
			PlayerAttack(selx,sely);
			return;
			}
			else
			{
			OverRide(Beep,false);
			break;
			}
		}
		else if (type == true)
		{
		OverRide(Accept,false);
		LockTarget(Battle.temp, selx, sely);
		return;
		}
		else if (GetTile(selx, sely, 2) == 4)
		{
		OverRide(Accept,false);
		UseItem(PXY(selx,sely));
		return;
		}
		else
		{
		OverRide(Beep,false);
		break;
		}
          }

          case KEY_ESCAPE: 
	  {
	  OverRide(Cancel,false);
	      for (i=-1*range -1; i< range+1; i++)
	      {
		for (j=-1*range -1; j<range+1;j++)
		{
		SetTile(player[Battle.temp].x+i, player[Battle.temp].y+j, 2, 0); 
		}
	      }
	    MoveCamera(player[Battle.temp].x*Game.tilesize, player[Battle.temp].y*Game.tilesize, 32,25); 
            escape_function();
            return;
          }

          case KEY_RIGHT: 
          {
		if (GetTile(selx+1, sely, 2) == 2 || GetTile(selx+1, sely, 2) == 4)// || type == true)
		{
		calc_damage = true;
		selx = selx + 1;
		SetCameraX(GetCameraX() + Game.tilesize);
	        GetScreenPosition(selx*Game.tilesize, sely*Game.tilesize);
		}
		else
		{
		OverRide(Beep,false);
		}
	    break;
          }

          case KEY_UP: 
          {
		if (GetTile(selx, sely-1, 2) == 2 || GetTile(selx, sely-1, 2) == 4)// || type == true)
		{
		calc_damage = true;
		sely = sely - 1;
		SetCameraY(GetCameraY() - Game.tilesize);
	        GetScreenPosition(selx*Game.tilesize, sely*Game.tilesize);
		}
		else
		{
		OverRide(Beep,false);
		}
	    break;
          }
          case KEY_DOWN: 
          {
		if (GetTile(selx, sely+1, 2) == 2 || GetTile(selx, sely+1, 2) == 4)// || type == true)
		{
		calc_damage = true;
		sely = sely + 1;
		SetCameraY(GetCameraY() + Game.tilesize);
	        GetScreenPosition(selx*Game.tilesize, sely*Game.tilesize);
		}
		else
		{
		OverRide(Beep,false);
		}
	    break;
          }
	  
          case KEY_LEFT: 
          {
		if (GetTile(selx-1, sely, 2) == 2 || GetTile(selx-1, sely, 2) == 4)// || type == true)
		{
		calc_damage = true;
		selx = selx - 1;
		SetCameraX(GetCameraX() - Game.tilesize);
	        GetScreenPosition(selx*Game.tilesize, sely*Game.tilesize);
		}
		else
		{
		OverRide(Beep,false);
		}
	    break;
          }
        }
      } // end handle input
    }
  } // end with
}



function BSkillMenu()
{
  if (this instanceof BSkillMenu == false) {
    return new BSkillMenu();
  }

  // default properties
  this.mfont            = LoadFont("New.rfn")
  this.window_style    = GetSystemWindowStyle()
  this.arrow           = GetSystemArrow();
  this.up_arrow        = LoadImage("Arrow_Up.png");
  this.down_arrow      = LoadImage("Arrow_Down.png");
  this.escape_function = function() { }

  this.items = new Array();
}

// add item
BSkillMenu.prototype.addItem = function(name, callback, color) {

  if (color == undefined) {
    color = White;
  }

  var item = new Object;
  item.name     = name;
  item.callback = callback;
  item.color    = color;
  this.items[this.items.length] = item;
}

// execute
BSkillMenu.prototype.execute = function(x, y, w, h, sel) {
  with (this) {
    var background = GrabImage(0, 0, GetScreenWidth(), GetScreenHeight());

    var text_height = mfont.getHeight();
    var shown_items = Math.floor(h / text_height);
    var yselection = 0;
    var top_yselection = 0;
    var xselection = 0;

    while (true) {
      // draw background
      background.blit(0, 0);

      // draw the window
      window_style.drawWindow(x, y, w, h);
      WindowStyle.drawWindow(5,345,215, 20);
	if (items[yselection*3 + xselection].name == "Back")
	{
        Font.drawText(25, 348, "Mp Cost: ");
	}
	else
	{
        Font.drawText(25, 348, "Mp Cost: " + Math.floor(Skill[items[yselection*3 + xselection].name][2]*player[Battle.temp].MpCost + 1));
	}

      // draw the menu items
	for (var i = 0; i < shown_items; i++) 
	{
		if (i < items.length/3)
		{
			for (j=0; j<3; j++)
			{
				if (3*i + j + top_yselection*3 < items.length)
				{
				mfont.setColorMask(items[3*i + j + top_yselection*3].color);
					if (items[3*i+j+top_yselection*3].name == "Back")
					{
					mfont.drawText(x + 32 + j* 160,     y + (i) * text_height,     "Back");
					}
					else
					{
					mfont.drawText(x + 32 + j* 160,     y + (i) * text_height,     Skill[items[3*i + j + top_yselection*3].name][0]);
					}
				}
			}
		}
	}

      // draw the selection arrow
      arrow.blit(x+xselection*160, y + (yselection - top_yselection) * text_height);
      // draw the up and down arrows if necessary
      if (top_yselection*3 > 0) {
        up_arrow.blit(x + w - up_arrow.width, y);
      }
      if (top_yselection + shown_items < items.length/3) {
        down_arrow.blit(x + w - down_arrow.width, y + text_height * shown_items - down_arrow.height);
      }

      FlipScreen();

      // handle keypresses
      while (AreKeysLeft()) {
        switch (GetKey()) {
          case KEY_ENTER: {
            var item = items[3*yselection + xselection];
		if (item.color == Gray || 3*yselection + xselection > items.length - 1)
	        {
		OverRide(Beep,false);
		break;
		}
		else
		{
		OverRide(Accept,false);
		SetDelayScript(0, item.callback);
		return;
		}
          }

          case KEY_ESCAPE: {
	    OverRide(Cancel,false);
            escape_function();
            return;
          }

          case KEY_DOWN: 
	  {
		if (yselection < items.length/3 - 1) 
		{
		OverRide(Mmove,false);
		yselection++;
			for (j=0; j<3; j++)
			{
				if (yselection*3 + xselection > items.length - 1)
				{
				xselection--;
				}
			}
			if (yselection >= top_yselection + shown_items) 
			{
			top_yselection++;
			}
		}
          break;
          }
	  case KEY_UP: 
	  {
		if (yselection > 0) 
		{
		OverRide(Mmove,false);
		yselection--;
			if (yselection < top_yselection) 
			{
			top_yselection--;
			}
		}
          break;
          }
          case KEY_RIGHT: 
	  {
		if (xselection >= 2 || yselection*3+xselection >= items.length - 1) 
		{
		OverRide(Beep,false);
		}
		else
		{
		OverRide(Mmove,false);
		xselection++;
		}
          break;
          }
          case KEY_LEFT: 
	  {
		if (xselection > 0) 
		{
		OverRide(Mmove,false);
		xselection--;
		}
		else
		{
		OverRide(Beep,false);
		}
          break;
          }
        }
      } // end handle input
    }
  } // end with
}






function BItemMenu()
{
  if (this instanceof BItemMenu == false) 
  {
    return new BItemMenu();
  }

  // default properties
  this.mfont            = LoadFont("New.rfn")
  this.window_style    = GetSystemWindowStyle()
  this.arrow           = GetSystemArrow();
  this.up_arrow        = LoadImage("Arrow_Up.png");
  this.down_arrow      = LoadImage("Arrow_Down.png");
  this.escape_function = function() { }

  this.items = new Array();
}

// add item
BItemMenu.prototype.addItem = function(name, callback, color) {

  if (color == undefined) 
  {
    color = White;
  }

  var item = new Object;
  item.name     = name;
  item.callback = callback;
  item.color    = color;
  this.items[this.items.length] = item;
}

// execute
BItemMenu.prototype.execute = function(x, y, w, h, draw_arrow, top) {
  with (this) {
    var background = GrabImage(0, 0, GetScreenWidth(), GetScreenHeight());

    var text_height = mfont.getHeight();
    var shown_items = Math.floor(h / (text_height*1.2));
    var Darrow = draw_arrow;
    var Top = top;
    
    if (Darrow == true)
    {
    var selection = Game.temp1st;
    var top_selection = Top;
    }
    else if (Darrow == false)
    {
    var selection = Game.temp1st;
    var top_selection = Top;
    }
    else
    {    
    var selection = 0;
    var top_selection = 0;    
    }
    while (true) {
      // draw background
      background.blit(0, 0);

      // draw the window
      window_style.drawWindow(x, y, w, h);
   
      // draw the menu items
      for (var i = 0; i < shown_items; i++) {
        if (i < items.length) 
        {
          if (ItemPlace[items[i + top_selection].name].num == -1)
          {
          }
          else
          {
	  mfont.setColorMask(items[i+top_selection].color)
          mfont.drawText(x + 64,     y + 8 + (1.2)* i * text_height,     " - " + Item[ItemPlace[items[i + top_selection].name].num].name);
          mfont.drawText(x + 32,     y + 8 + (1.2)* i * text_height,     Item[ItemPlace[items[i + top_selection].name].num].stock);
          }
        }
      }

      if (Darrow == true)
      {
        if (Math.pow(Game.temp1st - top_selection - 10, 2) <= 100) 
        {
        arrow.blitMask(x-8, y + 8 + (Game.temp1st - top_selection) * (1.2) * text_height, CreateColor(160,160,160,160));
        }
      }
      // draw the selection arrow
      arrow.blit(x, y + 8 + (selection - top_selection) * (1.2) * text_height);

      // draw the up and down arrows if necessary
      if (top_selection > 0) {
        up_arrow.blit(x + w - up_arrow.width, y);
      }
      if (top_selection + shown_items < items.length) {
        down_arrow.blit(x + w - down_arrow.width, y + text_height * (1.2)* shown_items - down_arrow.height);
      }
      FlipScreen();

      // handle keypresses
      while (AreKeysLeft()) {
        switch (GetKey()) {
          case KEY_ENTER: {
            var item = items[selection];
            Game.itemtemp = item.name;
            Game.temptop = top_selection
	    OverRide(Accept,false);
            SetDelayScript(0, item.callback);
            return;
          }

          case KEY_ESCAPE: {
            Game.temptop = top_selection;
            Game.temp1st = selection;
	    OverRide(Cancel, false);
            escape_function();
            return;
          }

          case KEY_DOWN: {
            if (selection < items.length - 1) {
	    OverRide(Mmove,false);
              selection++;
              if (selection >= top_selection + shown_items) {
                top_selection++;
              }
            }
            break;
          }

          case KEY_UP: {
            if (selection > 0) {
	    OverRide(Mmove,false);
              selection--;
              if (selection < top_selection) {
                top_selection--;
              }
            }
            break;
          }

          case KEY_PAGEDOWN: {
            if (selection < items.length - shown_items) 
	   {
	    OverRide(Mmove,false);
              selection = selection + shown_items;
              if (selection >= top_selection + shown_items) 
              {
                top_selection = top_selection + shown_items;
              }
              if (top_selection > items.length - shown_items - 1)
              {
              top_selection = items.length - shown_items;
              }
            }
            else if (selection == items.length - 1)
            {
            }
            else
            {
	    OverRide(Mmove,false);
            selection = items.length - 1;
            top_selection = items.length - shown_items;
            }
            break;
          }

          case KEY_PAGEUP: {
            if (selection > shown_items) {
	    OverRide(Mmove,false);
              selection = selection - shown_items;
              if (selection < top_selection) {
                top_selection = top_selection - shown_items;
                if (top_selection < 0)
                {
                top_selection = 0;
                }
              }
            }
            else if (selection == 0)
            {
            }
            else
            {
	    OverRide(Mmove,false);
            selection = 0;
            top_selection = 0;
            }
            break;
          }
        }
      } // end handle input
    }
  } // end with
}








function PlayerAttack(x,y, type)
{
if (type == undefined)
{
type = true;
}

var person = PXY(x,y);
FacePlayer(Battle.temp, x, y);
//ATTACK FRAMES HERE!!!

//player[Battle.temp].dir = GetPersonDirection("player" + Battle.temp);

for (m=0; m<player[Battle.temp][19]; m++)
{
CheckHit(person);
ReadyFrames(Battle.temp);
	if (player[Battle.target][6] > 0)
	{
	ResetFrames(Battle.target);
	var TheDamage = Math.floor((player[Battle.temp].Damage + player[Battle.temp].Damage*0.03*player[Battle.temp].Amod/player[Battle.target].Dmod*(player[Battle.temp][16] - player[person][17]))*(.9 + Math.random()*.2));

	TheDamage = Math.floor(TheDamage + (area[BattleArea[Battle.tempareanum].areainfo][GetTile(player[Battle.temp].x, player[Battle.temp].y, 0) - 5].elv - area[BattleArea[Battle.tempareanum].areainfo][GetTile(player[Battle.target].x, player[Battle.target].y,0) -5].elv)*Battle.elvdamage*TheDamage);


		if (player[Battle.temp][117] > 0)
		{
		TheDamage = Math.floor(TheDamage*1.33);
		}
		if (player[person][117] > 0)
		{
		TheDamage = Math.floor(TheDamage/1.33);
		}


		if (Item[player[Battle.temp][56]].range > 2)//>2 means it's a missle weapon, 2 means it's a spear.
		{
			DrawShot();
		}

			if (Math.random() < player[Battle.target][18]/100 || player[Battle.target][121] > 0)
			{
			//miss
			HitFrames(x, y, Battle.target, true);
			TakeOutDamage(Battle.target, TheDamage, true);
			}
			else//hit
			{
			Battle.temp3 = 0;
			Battle.temp4 = 0;
			//Elemental damage
				for (a=0; a<8; a++)
				{
					if (player[Battle.temp][30+a] > 0)
					{
					Battle.temp3 = Battle.temp3 + (TheDamage*(player[Battle.temp][30+a]/100*(100-player[Battle.target][22+a])/100));
					Battle.temp4 = Battle.temp4 + player[Battle.temp][30+a]/100
					}
				}
			TheDamage = Math.floor((1-Battle.temp4)*TheDamage + Battle.temp3);
			HitFrames(x, y, Battle.target, false);
				if (player[Battle.target][6] < TheDamage && player[Battle.temp][68] > 0)
				{
				TheDamage = player[Battle.target][6];
				}
			TakeOutDamage(Battle.target, TheDamage, false);

				if (player[Battle.temp][68] > 0)
				{
				TakeOutDamage(Battle.temp, -1*TheDamage, false);
				}

				if (player[Battle.temp][67] > 0)
				{
					if (player[Battle.target][9] < TheDamage*player[Battle.temp][67])
					{
					TheDamage = player[Battle.target][9];
					}
					else
					{
					TheDamage = Math.floor(TheDamage*player[Battle.temp][67]);
					}
				player[Battle.target][9] = player[Battle.target][9] - TheDamage;
				TakeOutDamage(Battle.temp, -1*TheDamage, false, false,true);
				}

				if (Item[player[Battle.temp][56]].skill > -1 && Math.random() < Item[player[Battle.temp][56]].schance)
				{
				DoSkill(Item[player[Battle.temp][56]].skill, 1, Battle.target);
				}
			}
	}
	else
	{
		if (Item[player[Battle.temp][56]].range > 2)
		{
		DrawShot();
		}
		
		if (Battle.target == -1)
		{
		CreatePerson("guy", "Attack.rss", true)
		SetPersonX("guy", Battle.tx*Game.tilesize + Game.tilesize/2 - 1);
		SetPersonY("guy", Battle.ty*Game.tilesize + Game.tilesize/2 - 1);
		SetPersonLayer("guy", 2);
		SetPersonScaleFactor("guy", 2,2);
		SetPersonDirection("guy", "east");
			for (l=0; l<7; l++)
			{
			SetPersonFrame("guy", l);
			RenderMap();
			BattleDraw1();
			FlipScreen();
			Delay(Battle.delay*3);
			}
		TakeOutDamage(Battle.target, TheDamage, true, false, false, Battle.tx, Battle.ty);
		DestroyPerson("guy");
		}
	}
RemoveCharm(Battle.target);
ResetFrames(Battle.target);
ResetFrames(Battle.temp);
player[Battle.target][102] = -1;//Reset the target of the monster
}


Battle.attacked = true;
//Counter Attack!

	if (Math.random() < player[Battle.target][91] && player[Battle.target][6] > 0 && (Math.abs(player[Battle.temp].x - player[Battle.target].x) + Math.abs(player[Battle.temp].y - player[Battle.target].y) <= Item[player[Battle.target][56]].range))
	{
	var tempy = Battle.temp;
	Battle.temp = Battle.target;

		if (player[Battle.target][90] == -1)
		{
		RenderMap();
		var string = "Counter!";
		BattleDraw1(false);
		WindowStyle.drawWindow(40,40, Font.getStringWidth(string) + 20,9+16);
		Font.drawTextBox(50,45, 600, 16, 0, string);
		FlipScreen();
		Delay(750);
		PlayerAttack2(tempy);
		}
		else
		{
		RenderMap();
		var string = "Counter Magic!";
		BattleDraw1(false);
		WindowStyle.drawWindow(40,40, Font.getStringWidth(string) + 20,9+16);
		Font.drawTextBox(50,45, 600, 16, 0, string);
		FlipScreen();
		Delay(750);

		//do skilly.
			if (player[Battle.target][9] >= Math.floor((Skill[player[Battle.target][90]][2]*player[Battle.temp].MpCost + 1)/2))
			{
			player[Battle.target][9] -= Math.floor((Skill[player[Battle.target][90]][2]*player[Battle.temp].MpCost + 1)/2);
			DoSkill2(player[Battle.target][90], tempy);
			}
			else
			{
			WindowBox("Not enough mp.", false);
			}
		}
	Battle.temp = tempy;
	}

CheckObjectives();
	if (Battle.cancel == false)
	{
		if (type == true)
		{
			if (Battle.movesleft == 0)
			{
			EndTurn();
			}
			else
 			{
			PlayerTurn(Battle.temp);
			}
		}
	}
}








function PlayerAttack2(person)//for counter attacks
{
FacePlayer(Battle.temp, person);
for (m=0; m<player[Battle.temp][19]; m++)
{
CheckHit(person);
ReadyFrames(Battle.temp);
	if (player[Battle.target][6] > 0)
	{
	ResetFrames(Battle.target);
	var TheDamage = Math.floor((player[Battle.temp].Damage + player[Battle.temp].Damage*0.03*player[Battle.temp].Amod/player[Battle.target].Dmod*(player[Battle.temp][16] - player[person][17]))*(.9 + Math.random()*.2));
	TheDamage = Math.floor(TheDamage + (area[BattleArea[Battle.tempareanum].areainfo][GetTile(player[Battle.temp].x, player[Battle.temp].y, 0) - 5].elv - area[BattleArea[Battle.tempareanum].areainfo][GetTile(player[Battle.target].x, player[Battle.target].y,0) -5].elv)*Battle.elvdamage*TheDamage);


	if (player[Battle.temp][117] > 0)
	{
	TheDamage = Math.floor(TheDamage*1.33);
	}
	if (player[person][117] > 0)
	{
	TheDamage = Math.floor(TheDamage/1.33);
	}


		if (Item[player[Battle.temp][56]].range > 2)//>2 means it's a missle weapon, 2 means it's a spear.
		{
			DrawShot();
		}

			if (Math.random() < player[Battle.target][18]/100 || player[Battle.target][121] > 0)
			{
			//miss
			HitFrames(player[Battle.temp].x, player[Battle.temp].y, Battle.target, true);
			TakeOutDamage(Battle.target, TheDamage, true);
			}
			else//hit
			{
			Battle.temp3 = 0;
			Battle.temp4 = 0;
			//Elemental damage
				for (a=0; a<8; a++)
				{
					if (player[Battle.temp][30+a] > 0)
					{
					Battle.temp3 = Battle.temp3 + (TheDamage*(player[Battle.temp][30+a]/100*(100-player[Battle.target][22+a])/100));
					Battle.temp4 = Battle.temp4 + player[Battle.temp][30+a]/100
					}
				}
			TheDamage = Math.floor((1-Battle.temp4)*TheDamage + Battle.temp3);

			HitFrames(player[Battle.temp].x, player[Battle.temp].y, Battle.target, false);
				if (player[Battle.target][6] < TheDamage && player[Battle.temp][68] > 0)
				{
				TheDamage = player[Battle.target][6];
				}
			TakeOutDamage(Battle.target, TheDamage, false);

				if (player[Battle.temp][68] > 0)
				{
				TakeOutDamage(Battle.temp, -1*TheDamage, false);
				}

				if (player[Battle.temp][67] > 0)
				{
					if (player[Battle.target][9] < TheDamage*player[Battle.temp][67])
					{
					TheDamage = player[Battle.target][9];
					}
					else
					{
					TheDamage = Math.floor(TheDamage*player[Battle.temp][67]);
					}
				player[Battle.target][9] = player[Battle.target][9] - TheDamage;
				TakeOutDamage(Battle.temp, -1*TheDamage, false, false,true);
				}

				if (Item[player[Battle.temp][56]].skill > -1 && Math.random() < Item[player[Battle.temp][56]].schance)
				{
				DoSkill(Item[player[Battle.temp][56]].skill, 1, Battle.target);
				}
			}
	}
	else
	{
	DrawShot();
		if (Battle.target == -1)
		{
		CreatePerson("guy", "Attack.rss", true)
		SetPersonX("guy", Battle.tx*Game.tilesize + Game.tilesize/2 - 1);
		SetPersonY("guy", Battle.ty*Game.tilesize + Game.tilesize/2 - 1);
		SetPersonLayer("guy", 2);
		SetPersonScaleFactor("guy", 2,2);
		SetPersonDirection("guy", "east");
			for (l=0; l<7; l++)
			{
			SetPersonFrame("guy", l);
			RenderMap();
			BattleDraw1();
			FlipScreen();
			Delay(Battle.delay*3);
			}
		TakeOutDamage(Battle.target, TheDamage, true, false, false, Battle.tx, Battle.ty);
		DestroyPerson("guy");
		}
	}
RemoveCharm(Battle.target);
ResetFrames(Battle.target);
ResetFrames(Battle.temp);
player[Battle.target][102] = -1;//Reset the target of the monster
}
}












function CheckHit(person, item)
{
	if (item == true && person == Battle.temp)
	{
	Battle.target = person;
	}
	else if (Item[player[Battle.temp][56]].range > 1 || item == true || item == false)
	{
	var movex = (player[person].x - player[Battle.temp].x)*Game.tilesize;
	var movey = (player[person].y - player[Battle.temp].y)*Game.tilesize;
	var theguy = -1;
	var tempything = 0;
	var dis = Math.sqrt(movex*movex + movey * movey);
	var speed = dis/4;
	var slope = movey/movex;
	var moveperx = 4/Math.sqrt(1+slope*slope);
	var movepery = moveperx*Math.sqrt(slope*slope);

	if (movex == 0)
	{
	movepery = 4;
	}
	if (movex < 0)
	{
	moveperx = moveperx*(-1);
	}
	if (movey < 0)
	{
	movepery = movepery*(-1);
	}
		for (i=1; i<speed; i++)
		{
		theguy = PXY(Math.floor((player[Battle.temp].x*Game.tilesize  + Game.tilesize/2 - 1 + moveperx*i)/Game.tilesize),Math.floor((player[Battle.temp].y*Game.tilesize  + Game.tilesize/2 - 1 + movepery*i)/Game.tilesize));
			if (GetTile(Math.floor(player[Battle.temp].x + moveperx*i/Game.tilesize),Math.floor(player[Battle.temp].y + movepery*i/Game.tilesize), 0) == 0)
			{
			tempything+= 1;
				if (tempything >= 2)
				{
				Battle.target = -1;
				Battle.tx = player[Battle.temp].x + Math.floor(moveperx*i*(1/Game.tilesize));
				Battle.ty = player[Battle.temp].y + Math.floor(movepery*i*(1/Game.tilesize));
				i = speed;
				}
			}
			else if (theguy == Battle.temp && (item==undefined || item == false))
			{
			}
			else if (theguy > -1 && (item==true || item == false || player[theguy][6] > 0))
			{
			tempything+= 1;
				if (tempything >= 3)
				{
				Battle.target = theguy; 
				i = speed;
				}
			}
		}
	}
	else if (item==undefined || item==false)
	{
	Battle.target = person;
	}

	if (Battle.target == Battle.temp && (item==undefined || item==false))
	{
	Battle.target = person;
	}
}

function DrawShot(item)
{
	if (item == true)
	{
		if (Battle.temp < 100)
		{
		var ammo = LoadImage(Item[ItemPlace[Game.temp1st].num].pic2);
		}
		else
		{
		var ammo = LoadImage(Item[Game.temp1st].pic2)
		}
	}
	else
	{
	var ammo = LoadImage(Item[player[Battle.temp][56]].pic2)
	}
	
	if (Battle.target == -1)
	{
	var xdif = Battle.tx - player[Battle.temp].x;
	var ydif = Battle.ty - player[Battle.temp].y;
	}
	else
	{
	var TTargetx = player[Battle.target].x;
	var TTargety = player[Battle.target].y;
	var TTempx = player[Battle.temp].x;
	var TTempy = player[Battle.temp].y;

		if (player[Battle.target][79] > 1)
		{
		TTargetx += (player[Battle.target][79]-1)/2; 
		TTargety += (player[Battle.target][79]-1)/2; 
		}

		if (player[Battle.temp][79] > 1)
		{
		TTempx = player[Battle.temp].x + (player[Battle.temp][79]-1)/2; 
		TTempy = player[Battle.temp].y + (player[Battle.temp][79]-1)/2; 
		}

	var xdif = TTargetx - TTempx;
	var ydif = TTargety - TTempy;
	}
	var angle = Math.atan(ydif/xdif);

	if (xdif < 0)
	{
	angle = angle + 3.14159;
	}

	if (item==true)
	{
	angle = 0;
	}


  var movex = xdif*Game.tilesize;
  var movey = ydif*Game.tilesize;
  var dis = Math.sqrt(movex*movex + movey * movey);
  var speed = dis/16;
  var slope = movey/movex;
  var xperframe = 16/Math.sqrt(1+slope*slope);
  var yperframe = xperframe*Math.sqrt(slope*slope);

  if (movex == 0)
  {
  yperframe = 16;
  }
  if (movex < 0)
  {
  xperframe = xperframe * (-1);
  }
  if (movey < 0)
  {
  yperframe = yperframe * (-1);
  }

  var xstart = player[Battle.temp].x;
  var ystart = player[Battle.temp].y;
	if (player[Battle.temp][79] > 1)
	{
	xstart += (player[Battle.temp][79]-1)/2;
	ystart += (player[Battle.temp][79]-1)/2;
	}


  for(i=0; i<speed; i++)
  {
	GetScreenPosition(Math.floor(player[Battle.temp].x*Game.tilesize + Game.tilesize + i*xperframe), Math.floor(player[Battle.temp].y*Game.tilesize + Game.tilesize + i*yperframe))
	RenderMap();
	ammo.rotateBlit(Game.C1-24, Game.C2+32, angle);
	FlipScreen();
	Delay(Battle.delay);
  }
}



function ReadyFrames(person)
{
	SetPersonDirection("player" + person, "ready");
	if (player[person].dir == "injury")
	{
	SetPersonFrame("player" + person, GetPersonFrame("player" + person) - 5);
	}
	else	if (player[person].dir == "north")	
	{
	SetPersonFrame("player" + person, 3);
	}
	else if (player[person].dir == "south")
	{
	SetPersonFrame("player" + person, 0);
	}
	else if (player[person].dir == "west")
	{
	SetPersonFrame("player" + person, 1);
	}
	else
	{
	SetPersonFrame("player" + person, 2);
	}
}

function InjureFrames(person)
{
	if (player[person][6] > 0 && player[person][104] <= 0)
	{
	SetPersonDirection("player" + person, "injury")
		if (player[person].dir == "south")
		{
		SetPersonFrame("player" + person, 0)
		}
		else if (player[person].dir == "west")
		{
		SetPersonFrame("player" + person, 1)
		}
		else if (player[person].dir == "east")
		{
		SetPersonFrame("player" + person, 2)
		}
		else if (player[person].dir == "north")
		{
		SetPersonFrame("player" + person, 3)
		}
	}
}

function ResetFrames(person)
{
	if (player[person].dir == undefined)
	{
	}
	else
	{
	SetPersonLayer("player" + person, 2);
		if (player[person][6] <= 0)
		{
		player[person][6] = 0;
		SetPersonDirection("player" + person, "injury");
		SetPersonFrame("player" + person, 4);
		SetPersonLayer("player" + person, 1);
		}
		else if (player[person][104] > 0)
		{
		SetPersonDirection("player" + person, "injury")
			if (player[person].dir == "south")
			{
			SetPersonFrame("player" + person, 9)
			}
			else if (player[person].dir == "west")
			{
			SetPersonFrame("player" + person, 10)
			}
			else if (player[person].dir == "east")
			{
			SetPersonFrame("player" + person, 11)
			}
			else if (player[person].dir == "north")
			{
			SetPersonFrame("player" + person, 12)
			}
		}
		else if (player[person].doingskill > -1)
		{
		SetPersonDirection("player" + person, "ready")
			if (player[person].dir == "south")
			{
			SetPersonFrame("player" + person, 0)
			}
			else if (player[person].dir == "west")
			{
			SetPersonFrame("player" + person, 1)
			}
			else if (player[person].dir == "east")
			{
			SetPersonFrame("player" + person, 2)
			}
			else if (player[person].dir == "north")
			{
			SetPersonFrame("player" + person, 3)
			}
		}
		else if (player[person][6] < player[person][7]/4)
		{
		SetPersonDirection("player" + person, "injury")
			if (player[person].dir == "south")
			{
			SetPersonFrame("player" + person, 5)
			}
			else if (player[person].dir == "west")
			{
			SetPersonFrame("player" + person, 6)
			}
			else if (player[person].dir == "east")
			{
			SetPersonFrame("player" + person, 7)
			}
			else if (player[person].dir == "north")
			{
			SetPersonFrame("player" + person, 8)
			}
		}
		else
		{
		SetPersonDirection("player" + person, player[person].dir)
		SetPersonFrame("player" + person, 0);
		}
	}
}

function Move(name, dir, amount, arrow, BattleDraw, camera)
{
if (arrow == undefined)
{
arrow = false;
}
if (BattleDraw == undefined)
{
	if (Battle.cancel == true)
	{
	}
	else
	{
	BattleDraw = true;
	}
}
if (camera == undefined)
{
	if (Battle.cancel == true)
	{
	}
	else
	{
	camera = true;
	}
}

Game.tempx = GetPersonX(name);
Game.tempy = GetPersonY(name);
Game.tempname = name;
Game.tempcx = GetCameraX();
Game.tempcy = GetCameraY();

  if (dir == "right")
  {
  SetPersonDirection(name, "east");
    for (i=0; i<Math.floor(Game.tilesize/(2*Battle.fskip)); i++)
    {
	if (camera == true)
	{
	SetCameraX(GetCameraX() + Battle.fskip);
	}
    SetPersonX(name, GetPersonX(name) + Battle.fskip);
    RenderMap();
	if (BattleDraw == true)
	{
	BattleDraw1(arrow);
	}
    FlipScreen();
    Delay(Battle.delay);
    }
    SetPersonFrame(name, GetPersonFrame(Game.tempname) + 1);
    for (i=0; i<Math.floor(Game.tilesize/(2*Battle.fskip)); i++)
    {
	if (camera == true)
	{
	SetCameraX(GetCameraX() + Battle.fskip);
	}
    SetPersonX(name, GetPersonX(name) + Battle.fskip);
    RenderMap();
	if (BattleDraw == true)
	{
	BattleDraw1(arrow);
	}
    FlipScreen();
    Delay(Battle.delay);
    }
  SetPersonX(Game.tempname, Game.tempx + Game.tilesize)
  if (camera == true)
  {
  SetCameraX(Game.tempcx + Game.tilesize);
  }
  }
  else if (dir == "left")
  {
  SetPersonDirection(name, "west");
    for (i=0; i<Math.floor(Game.tilesize/(2*Battle.fskip)); i++)
    {
	if (camera == true)
	{
	SetCameraX(GetCameraX() - Battle.fskip);
	}
    SetPersonX(name, GetPersonX(name) - Battle.fskip);
    RenderMap();
	if (BattleDraw == true)
	{
	BattleDraw1(arrow);
	}
    FlipScreen();
    Delay(Battle.delay);
    }
    SetPersonFrame(name, GetPersonFrame(Game.tempname) + 1);
    for (i=0; i<Math.floor(Game.tilesize/(2*Battle.fskip)); i++)
    {
	if (camera == true)
	{
	SetCameraX(GetCameraX() - Battle.fskip);
	}
    SetPersonX(name, GetPersonX(name) - Battle.fskip);
    RenderMap();
	if (BattleDraw == true)
	{
	BattleDraw1(arrow);
	}
    FlipScreen();
    Delay(Battle.delay);
    }
  SetPersonX(Game.tempname, Game.tempx - Game.tilesize)
	if (camera == true)
	{
	SetCameraX(Game.tempcx - Game.tilesize);
	}
  }
  else if (dir == "up")
  {
  SetPersonDirection(name, "north");
    for (i=0; i<Math.floor(Game.tilesize/(2*Battle.fskip)); i++)
    {
	if (camera == true)
	{
	SetCameraY(GetCameraY() - Battle.fskip);
	}
    SetPersonY(name, GetPersonY(name) - Battle.fskip);
    RenderMap();
	if (BattleDraw == true)
	{
	BattleDraw1(arrow);
	}
    FlipScreen();
    Delay(Battle.delay);
    }
    SetPersonFrame(name, GetPersonFrame(Game.tempname) + 1);
    for (i=0; i<Math.floor(Game.tilesize/(2*Battle.fskip)); i++)
    {
	if (camera == true)
	{
	SetCameraY(GetCameraY() - Battle.fskip);
	}
    SetPersonY(name, GetPersonY(name) - Battle.fskip);
    RenderMap();
	if (BattleDraw == true)
	{
	BattleDraw1(arrow);
	}
    FlipScreen();
    Delay(Battle.delay);
    }
	if (camera == true)
	{
	SetCameraY(Game.tempcy - Game.tilesize);
	}
   SetPersonY(Game.tempname, Game.tempy - Game.tilesize)
  }
  else if (dir == "down")
  {
  SetPersonDirection(name, "south");
    for (i=0; i<Math.floor(Game.tilesize/(2*Battle.fskip)); i++)
    {
	if (camera == true)
	{
	SetCameraY(GetCameraY() + Battle.fskip);
	}
    SetPersonY(name, GetPersonY(name) + Battle.fskip);
    RenderMap();
	if (BattleDraw == true)
	{
	BattleDraw1(arrow);
	}
    FlipScreen();
    Delay(Battle.delay);
    }
    SetPersonFrame(name, GetPersonFrame(Game.tempname) + 1);
    for (i=0; i<Math.floor(Game.tilesize/(2*Battle.fskip)); i++)
    {
	if (camera == true)
	{
	SetCameraY(GetCameraY() + Battle.fskip);
	}
    SetPersonY(name, GetPersonY(name) + Battle.fskip);
    RenderMap();
	if (BattleDraw == true)
	{
	BattleDraw1(arrow);
	}
    FlipScreen();
    Delay(Battle.delay);
    }
    SetPersonY(Game.tempname, Game.tempy + Game.tilesize)
	if (camera == true)
	{
	SetCameraY(Game.tempcy + Game.tilesize);
	}
  }

  if (GetPersonFrame(name) == 0 || GetPersonFrame(name) == 3)
  {
  SetPersonFrame(name, 0);
  }
  else
  {
  SetPersonFrame(name, 2);
  }  

if (BattleDraw == true)
{
player[Battle.temp].dir = GetPersonDirection("player" + Battle.temp)
}
EatKey();
}

function BattleDraw1(boo)//For the current Players
{
//Font = LoadFont("bigmain.rfn");
var Image = LoadImage(player[Battle.temp][3]);
  if (boo == true)
  {
  BArrow.blit(Game.C1 - Game.tilesize/2, Game.C2 - Game.tilesize/2); 
  }
  WindowStyle.drawWindow(5,375,480, 100);
  WindowStyle.drawWindow(5,345,170, 20);

  if (player[Battle.temp][100] == 1 || (player[Battle.temp][100] == -1 && player[Battle.temp][101] == 1))
  {
  Image.transformBlit(15, 385, 95, 385, 95, 465, 15, 465);
  Font.drawText(125, 390, player[Battle.temp][0]);
  Font.drawText(125, 410, "Hp: " + player[Battle.temp][6] + "/" + player[Battle.temp][7]);
  Font.drawText(125, 430, "Mp: " + player[Battle.temp][9] + "/" + player[Battle.temp][10]);
  Font.drawText(125, 450, "Level: " + player[Battle.temp][38] + "  To go: " + player[Battle.temp][41]);
  Font.drawText(25, 348, "Moves: " + Battle.movesleft);
  }
  else if (player[Battle.temp][100] == 0)
  {
  Image.transformBlit(15, 385, 95, 385, 95, 465, 15, 465);
  Font.drawText(125, 390, player[Battle.temp][0]);
  Font.drawText(125, 410, "Hp: " + player[Battle.temp][6] + "/" + player[Battle.temp][7]);
  Font.drawText(125, 430, "Mp: " + player[Battle.temp][9] + "/" + player[Battle.temp][10]);
  Font.drawText(125, 450, "Level: " + player[Battle.temp][38] + "  To go: ?");

  Font.drawText(25, 348, "Moves: " + Battle.movesleft);
  }
  else
  {
  Image.transformBlit(15, 385, 95, 385, 95, 465, 15, 465);
  Font.drawText(125, 390, player[Battle.temp][0]);
  Font.drawText(125, 410, "Hp: ???/???");
  Font.drawText(125, 430, "Mp: ???/???");
  Font.drawText(125, 450, "Level: ??  To go: ???"); 
  Font.drawText(25, 348, "Moves: ?");
  }
}

function BattleDraw2(Target, Hpdamage, Mpdamage)//For target Player
{
if (Hpdamage == undefined)
{
Hpdamage = 0;
}
if (Mpdamage == undefined)
{
Mpdamage = 0;
}

  WindowStyle.drawWindow(5,5,580, 100);

  if (player[Target][100] == 1)
  {
  LoadImage(player[Target][3]).transformBlit(15, 15, 95, 15, 95, 95, 15, 95);
  Font.drawText(125, 20, player[Target][0]);
  Font.drawText(125, 40, "Hp: " + player[Target][6] + "/" + player[Target][7]);
  Font.drawText(125, 60, "Mp: " + player[Target][9] + "/" + player[Target][10]);
  Font.drawText(125, 80, "Level: " + player[Target][38] + "  To go: " + player[Target][41]);
  }
  else if (player[Target][100] == 0)
  {
  LoadImage(player[Target][3]).transformBlit(15, 15, 95, 15, 95, 95, 15, 95);
  Font.drawText(125, 20, player[Target][0]);
  Font.drawText(125, 40, "Hp: " + player[Target][6] + "/" + player[Target][7]);
  Font.drawText(125, 60, "Mp: " + player[Target][9] + "/" + player[Target][10]);
  Font.drawText(125, 80, "Level: " + player[Target][38] + "  To go: ?");
  }
  else
  {
  LoadImage(player[Target][3]).transformBlit(15, 15, 95, 15, 95, 95, 15, 95);
  Font.drawText(125, 20, player[Target][0]);
  Font.drawText(125, 40, "Hp: ???/???");
  Font.drawText(125, 60, "Mp: ???/???");
  Font.drawText(125, 80, "Level: ??  To go: ???"); 
  }

  if (Hpdamage > 0)
  {
  Font.drawText(301, 40, " - " + Hpdamage);
  }
  else if (Hpdamage < 0)
  {
  GFont.drawText(301, 40, " + " + Hpdamage*(-1));
  }
  if (Mpdamage > 0)
  {
  Font.drawText(301, 60, " - " + Mpdamage);
  }
  else if (Mpdamage < 0)
  {
  GFont.drawText(301, 60, " + " + Mpdamage*(-1));
  }
}

function GetScreenPosition(mapx,mapy)
{
Game.C1 = GetScreenWidth()/2 - (GetCameraX() - mapx) + 2;
Game.C2 = GetScreenHeight()/2 - (GetCameraY() - mapy) - 64
}




//Movement stuff

function Move1(x,y, close, movesleft)
{
Battle.CX = x;
Battle.CY = y;

if (movesleft == undefined)
{
Battle.movesleft = player[Battle.temp][21];
}
else
{
Battle.movesleft = movesleft;
}
Battle.movesuccess = false;

Battle.tempx = GetPersonX("player" + Battle.temp)/Game.tilesize - Game.tilesize/2 + 1;
Battle.tempy = GetPersonY("player" + Battle.temp)/Game.tilesize - Game.tilesize/2 + 1;

Battle.close = close;//How many blocks away from the target do we want to be? 

    for (k=0; k<player[Battle.temp][21]; k++)
    {
    Move2();
    }

//Reset target to move to
Battle.CX = x;
Battle.CY = y;

    for (k=0; k<player[Battle.temp][21]; k++)
    {
    Move2();
    }
}

function Move2()
{
Battle.movesuccess = false;

    Battle.Mx = player[Battle.temp].x*Game.tilesize + Game.tilesize/2 - 1;
    Battle.My = player[Battle.temp].y*Game.tilesize + Game.tilesize/2 - 1;
    Battle.Tx = Battle.CX*Game.tilesize + Game.tilesize/2 - 1;
    Battle.Ty = Battle.CY*Game.tilesize + Game.tilesize/2 - 1;
    Battle.Moved = false;
    Battle.xt = Battle.Mx - Battle.Tx;
    Battle.yt = Battle.My - Battle.Ty;
/*
	if (Math.sqrt(Battle.xt*Battle.xt) + Math.sqrt(Battle.yt*Battle.yt) <= Battle.close*Game.tilesize)
	{
		Battle.Moved = true;
                Battle.movesuccess = true;
	}
	if (player[Battle.temp][79] > 1)
	{
*/
		for (a=0; a<player[Battle.temp][79]; a++)
		{
			for (b=0; b<player[Battle.temp][79]; b++)
			{
			Battle.Mx = (player[Battle.temp].x+a)*Game.tilesize + Game.tilesize/2 - 1;
			Battle.My = (player[Battle.temp].y+b)*Game.tilesize + Game.tilesize/2 - 1;
			Battle.Tx = Battle.CX*Game.tilesize + Game.tilesize/2 - 1;
			Battle.Ty = Battle.CY*Game.tilesize + Game.tilesize/2 - 1;
			Battle.xt = Battle.Mx - Battle.Tx;
			Battle.yt = Battle.My - Battle.Ty;

				if (Math.sqrt(Battle.xt*Battle.xt) + Math.sqrt(Battle.yt*Battle.yt) <= Battle.close*Game.tilesize)
				{
				Battle.Moved = true;
				Battle.movesuccess = true;
				}
			}
		}
/*
	}
*/
  Battle.temptile = GetTile(player[Battle.temp].x, player[Battle.temp].y, 0) - 5;
  Battle.temptile2 = GetTile(Battle.CX, Battle.CY, 0) - 5;
  
  if ((Battle.temptile < Battle.temptile2 || Battle.temptile > Battle.temptile2) && Battle.temptile2 > -1)
  {
    if (area[BattleArea[Battle.tempareanum].areainfo][Battle.temptile][Battle.temptile2] == undefined)//Basicly if this is defined
    {
      //Go to the default waypoint
      Battle.waypoint = area[BattleArea[Battle.tempareanum].areainfo][Battle.temptile][-1];
      MoveToTarget(Barea[BattleArea[Battle.tempareanum].areainfo][Battle.waypoint].x, Barea[BattleArea[Battle.tempareanum].areainfo][Battle.waypoint].y, 0);
    }
    else//Go to the set waypoint
    {
      Battle.waypoint = area[BattleArea[Battle.tempareanum].areainfo][Battle.temptile][Battle.temptile2];
      MoveToTarget(Barea[BattleArea[Battle.tempareanum].areainfo][Battle.waypoint].x, Barea[BattleArea[Battle.tempareanum].areainfo][Battle.waypoint].y, 0);
    }
  }
  else//move directly to the point
  {
    MoveToTarget(Battle.CX, Battle.CY, Battle.close);
  }  
}

function MoveToTarget(x,y, amount)//Moves towards the target
{
  if (Battle.movesleft > 0)
  {
    Battle.Mx = player[Battle.temp].x*Game.tilesize + Game.tilesize/2 - 1;
    Battle.My = player[Battle.temp].y*Game.tilesize + Game.tilesize/2 - 1;
    Battle.Tx = x*Game.tilesize + Game.tilesize/2 - 1;
    Battle.Ty = y*Game.tilesize + Game.tilesize/2 - 1;
    Battle.xt = (Battle.Mx - Battle.Tx)*(Battle.Mx - Battle.Tx);
    Battle.yt = (Battle.My - Battle.Ty)*(Battle.My - Battle.Ty);

    if (Battle.xt < Battle.yt)
    {
    var Priority = "y";
    }
    else
    {
    var Priority = "x";
    }

	if (Battle.xt + Battle.yt > 0)
	{
	if (Priority == "x")
	{
		if (Battle.Tx <= Battle.Mx || Battle.Moved == true || BattleObstruct(Battle.Mx + Game.tilesize, Battle.My) == true)
		{
		}
		else
		{
		Battle.Moved = true;
		Battle.movesleft = Battle.movesleft - 1;
		player[Battle.temp].x = player[Battle.temp].x + 1;
		Move("player" + Battle.temp, "right");
		}

		if (Battle.Tx >= Battle.Mx || Battle.Moved == true || BattleObstruct(Battle.Mx - Game.tilesize, Battle.My) == true)
		{
		}
		else
		{
		Battle.Moved = true;
		Battle.movesleft = Battle.movesleft - 1;
		player[Battle.temp].x = player[Battle.temp].x - 1;
		Move("player" + Battle.temp, "left");
		}
	}
	else
	{
		if (Battle.Ty <= Battle.My || Battle.Moved == true || BattleObstruct(Battle.Mx, Battle.My + Game.tilesize) == true)
		{
		}       
		else
		{
		Battle.Moved = true;
		Battle.movesleft = Battle.movesleft - 1;
		player[Battle.temp].y = player[Battle.temp].y + 1;
		Move("player" + Battle.temp, "down");
		}

		if (Battle.Ty >= Battle.My || Battle.Moved == true || BattleObstruct(Battle.Mx, Battle.My - Game.tilesize) == true)
		{
		}
		else
		{
		Battle.Moved = true;
		Battle.movesleft = Battle.movesleft - 1;
		player[Battle.temp].y = player[Battle.temp].y - 1;
		Move("player" + Battle.temp, "up");
		}
	}

		if (Battle.Tx <= Battle.Mx || Battle.Moved == true || BattleObstruct(Battle.Mx + Game.tilesize, Battle.My) == true)
		{
		}
		else
		{
		Battle.Moved = true;
		Battle.movesleft = Battle.movesleft - 1;
		player[Battle.temp].x = player[Battle.temp].x + 1;
		Move("player" + Battle.temp, "right");
		}

		if (Battle.Tx >= Battle.Mx || Battle.Moved == true || BattleObstruct(Battle.Mx - Game.tilesize, Battle.My) == true)
		{
		}       
		else
		{
		Battle.Moved = true;
		Battle.movesleft = Battle.movesleft - 1;
		player[Battle.temp].x = player[Battle.temp].x - 1;
		Move("player" + Battle.temp, "left");
		}

		if (Battle.Ty <= Battle.My || Battle.Moved == true || BattleObstruct(Battle.Mx, Battle.My + Game.tilesize) == true)
		{
		}       
		else
		{
		Battle.Moved = true;
		Battle.movesleft = Battle.movesleft - 1;
		player[Battle.temp].y = player[Battle.temp].y + 1;
		Move("player" + Battle.temp, "down");
		}

		if (Battle.Ty >= Battle.My || Battle.Moved == true || BattleObstruct(Battle.Mx, Battle.My - Game.tilesize) == true)
		{
		}       
		else
		{
		Battle.Moved = true;
		Battle.movesleft = Battle.movesleft - 1;
		player[Battle.temp].y = player[Battle.temp].y - 1;
		Move("player" + Battle.temp, "up");
		}

	//The Monster is blocked from going to the target
	if (Battle.Moved == true || Battle.movesuccess == true)
	{
	}
	else
	{
		if (Priority == "x")
		{
			if (Battle.Mx > Battle.Tx)
			{
			//Left
				if (BattleObstruct(player[Battle.temp].x*Game.tilesize + Game.tilesize/2  - 1, (player[Battle.temp].y-1)*Game.tilesize + Game.tilesize/2  - 1) == true || BattleObstruct((player[Battle.temp].x -1)*Game.tilesize + Game.tilesize/2  - 1, (player[Battle.temp].y-1)*Game.tilesize + Game.tilesize/2  - 1) == true || Battle.Moved == true)
				{
				}
				else
				{
				Battle.Moved = true;
				Battle.movesleft = Battle.movesleft - 1;
				player[Battle.temp].y = player[Battle.temp].y - 1;
				Move("player" + Battle.temp, "up");
					if (Battle.movesleft > 0)
					{
					Battle.movesleft = Battle.movesleft - 1;
					player[Battle.temp].x = player[Battle.temp].x - 1;
					Move("player" + Battle.temp, "left");
					}
				}

				if (BattleObstruct(player[Battle.temp].x*Game.tilesize + Game.tilesize/2  - 1, (player[Battle.temp].y+1)*Game.tilesize + Game.tilesize/2  - 1) == true || BattleObstruct((player[Battle.temp].x -1)*Game.tilesize + Game.tilesize/2  - 1, (player[Battle.temp].y+1)*Game.tilesize + Game.tilesize/2  - 1) == true || Battle.Moved == true)
				{
				}
				else
				{
				Battle.Moved = true;
				Battle.movesleft = Battle.movesleft - 1;
				player[Battle.temp].y = player[Battle.temp].y + 1;
				Move("player" + Battle.temp, "down");
					if (Battle.movesleft > 0)
					{
					Battle.movesleft = Battle.movesleft - 1;
					player[Battle.temp].x = player[Battle.temp].x - 1;
					Move("player" + Battle.temp, "left");
					}
				}
			}
			else
			{
			//Right
				if (BattleObstruct(player[Battle.temp].x*Game.tilesize + Game.tilesize/2  - 1, (player[Battle.temp].y-1)*Game.tilesize + Game.tilesize/2  - 1) == true || BattleObstruct((player[Battle.temp].x +1)*Game.tilesize + Game.tilesize/2  - 1, (player[Battle.temp].y-1)*Game.tilesize + Game.tilesize/2  - 1) == true || Battle.Moved == true)
				{
				}
				else
				{
				Battle.Moved = true;
				Battle.movesleft = Battle.movesleft - 1;
				player[Battle.temp].y = player[Battle.temp].y - 1;
				Move("player" + Battle.temp, "up");
					if (Battle.movesleft > 0)
					{
					Battle.movesleft = Battle.movesleft - 1;
					player[Battle.temp].x = player[Battle.temp].x + 1;
					Move("player" + Battle.temp, "right");
					}
				}

				if (BattleObstruct(player[Battle.temp].x*Game.tilesize + Game.tilesize/2  - 1, (player[Battle.temp].y+1)*Game.tilesize + Game.tilesize/2  - 1) == true || BattleObstruct((player[Battle.temp].x +1)*Game.tilesize + Game.tilesize/2  - 1, (player[Battle.temp].y+1)*Game.tilesize + Game.tilesize/2  - 1) == true || Battle.Moved == true)
				{
				}
				else
				{
				Battle.Moved = true;
				Battle.movesleft = Battle.movesleft - 1;
				player[Battle.temp].y = player[Battle.temp].y + 1;
				Move("player" + Battle.temp, "down");
					if (Battle.movesleft > 0)
					{
					Battle.movesleft = Battle.movesleft - 1;
					player[Battle.temp].x = player[Battle.temp].x + 1;
					Move("player" + Battle.temp, "right");
					}
				}
			}
		}
		else
		{
			if (Battle.My > Battle.Ty)
			{
			//Up
				if (BattleObstruct((player[Battle.temp].x + 1)*Game.tilesize + Game.tilesize/2  - 1, player[Battle.temp].y*Game.tilesize + Game.tilesize/2  - 1) == true || BattleObstruct((player[Battle.temp].x + 1)*Game.tilesize + Game.tilesize/2  - 1, (player[Battle.temp].y-1)*Game.tilesize + Game.tilesize/2  - 1) == true || Battle.Moved == true)
				{
				}
				else
				{
				Battle.Moved = true;
				Battle.movesleft = Battle.movesleft - 1;
				player[Battle.temp].x = player[Battle.temp].x + 1;
				Move("player" + Battle.temp, "right");
					if (Battle.movesleft > 0)
					{
					Battle.movesleft = Battle.movesleft - 1;
					player[Battle.temp].y = player[Battle.temp].y - 1;
					Move("player" + Battle.temp, "up");
					}
				}

				if (BattleObstruct((player[Battle.temp].x - 1)*Game.tilesize + Game.tilesize/2  - 1, player[Battle.temp].y*Game.tilesize + Game.tilesize/2  - 1) == true || BattleObstruct((player[Battle.temp].x - 1)*Game.tilesize + Game.tilesize/2  - 1, (player[Battle.temp].y-1)*Game.tilesize + Game.tilesize/2  - 1) == true || Battle.Moved == true)
				{
				}
				else
				{
				Battle.Moved = true;
				Battle.movesleft = Battle.movesleft - 1;
				player[Battle.temp].x = player[Battle.temp].x - 1;
				Move("player" + Battle.temp, "left");
					if (Battle.movesleft > 0)
					{
					Battle.movesleft = Battle.movesleft - 1;
					player[Battle.temp].y = player[Battle.temp].y - 1;
					Move("player" + Battle.temp, "up");
					}
				}
			}
			else
			{
			//Down
				if (BattleObstruct((player[Battle.temp].x+1)*Game.tilesize + Game.tilesize/2  - 1, player[Battle.temp].y*Game.tilesize + Game.tilesize/2  - 1) == true || BattleObstruct((player[Battle.temp].x +1)*Game.tilesize + Game.tilesize/2  - 1, (player[Battle.temp].y+1)*Game.tilesize + Game.tilesize/2  - 1) == true || Battle.Moved == true)
				{
				}
				else
				{
				Battle.Moved = true;
				Battle.movesleft = Battle.movesleft - 1;
				player[Battle.temp].x = player[Battle.temp].x + 1;
				Move("player" + Battle.temp, "right");
					if (Battle.movesleft > 0)
					{
					Battle.movesleft = Battle.movesleft - 1;
					player[Battle.temp].y = player[Battle.temp].y + 1;
					Move("player" + Battle.temp, "down");
					}
				}

				if (BattleObstruct((player[Battle.temp].x-1)*Game.tilesize + Game.tilesize/2  - 1, player[Battle.temp].y*Game.tilesize + Game.tilesize/2  - 1) == true || BattleObstruct((player[Battle.temp].x -1)*Game.tilesize + Game.tilesize/2  - 1, (player[Battle.temp].y+1)*Game.tilesize + Game.tilesize/2  - 1) == true || Battle.Moved == true)
				{
				}
				else
				{
				Battle.Moved = true;
				Battle.movesleft = Battle.movesleft - 1;
				player[Battle.temp].x = player[Battle.temp].x - 1;
				Move("player" + Battle.temp, "left");
					if (Battle.movesleft > 0)
					{
					Battle.movesleft = Battle.movesleft - 1;
					player[Battle.temp].y = player[Battle.temp].y + 1;
					Move("player" + Battle.temp, "down");
					}
				}
			}
		}
        Battle.Tx = Battle.CX*Game.tilesize + Game.tilesize/2 - 1;
        Battle.Ty = Battle.CY*Game.tilesize + Game.tilesize/2 - 1;
        Battle.xt = (Battle.Mx - Battle.Tx)*(Battle.Mx - Battle.Tx);
	Battle.yt = (Battle.My - Battle.Ty)*(Battle.My - Battle.Ty);

	Battle.tdisy = (Battle.Ty - Battle.My)*(Battle.Ty - Battle.My);
	Battle.tdisx = (Battle.Tx - Battle.Mx)*(Battle.Tx - Battle.Mx);
	}
	}
    Battle.Moved = false;
  }
}

function HitFrames(x,y, person, miss)
{
	if (player[person][104] > 0)//If the target is stoned, make it a miss 
	{
	miss = true;
	}
	if (player[person][79] > 1)
	{
	var tempy = (player[person][79]-1)*Game.tilesize/2;
	}
	else
	{
	tempy = 0;
	}
CreatePerson("Attack", "Attack.rss", true);
SetPersonScaleAbsolute("Attack", 32, 32);
SetPersonLayer("Attack", 2);
SetPersonX("Attack", player[person].x*Game.tilesize+Game.tilesize/2 - 1+ tempy);
SetPersonY("Attack", player[person].y*Game.tilesize+Game.tilesize/2 - 1 + tempy);
SetPersonDirection("Attack", Item[player[Battle.temp][56]].atk);

InjureFrames(person);

if (miss == false)
{
Hit[Item[player[Battle.temp][56]].hit].play(false);
	for (l=0; l<7; l++)
	{
	SetPersonFrame("Attack", l)
		if (Math.floor(l/2) == l/2)
		{
		SetPersonX("player" + person, player[person].x*Game.tilesize + Game.tilesize/2)
		}
		else
		{
		SetPersonX("player" + person, player[person].x*Game.tilesize + Game.tilesize/2 - 2)
		}

	RenderMap()
	BattleDraw1();
	FlipScreen();
	Delay(Battle.delay*3);
	}
SetPersonX("player" + person, player[person].x*Game.tilesize + Game.tilesize/2 - 1)
DestroyPerson("Attack");
}
else//a miss
{
Miss[Item[player[Battle.temp][56]].hit].play(false);
SetPersonDirection("player" + person, "ready")
	for (l=0; l<7; l++)
	{
	SetPersonFrame("Attack", l)
	RenderMap()
	BattleDraw1();
	FlipScreen();
	Delay(Battle.delay*3);
	}
SetPersonX("player" + person, player[person].x*Game.tilesize + Game.tilesize/2 - 1)
DestroyPerson("Attack");
}

}







